package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.Sketch;
import easik.sketch.vertex.EntityNode;

/**
 * Action for the delete entity option in the popup menu.
 * 
 * @author Kevin Green 2006
 * @since 2006-08-02 Kevin Green
 * @version 2006-08-02 Kevin Green
 */
public class DeleteEntityAction extends AbstractAction{
	
	/**
	 * Sets up delete entity action
	 */
	public DeleteEntityAction(){
		super("Delete Entity");	
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_D));
		putValue(AbstractAction.SHORT_DESCRIPTION, "Deletes the currently selected entity");
	}
	
	/**
	 * Called when clicked upon, will delete entity. 
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get Sketch object
		Sketch _ourSketch = Easik.getInstance().getFrame().getSketch();
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		
		if(curSelected instanceof EntityNode){
			Easik.getInstance().getFrame().getSketch().removeEntity((EntityNode)curSelected);
			
			Easik.getInstance().getFrame().getSketch().setDirty(true);
		}
	}
}
